% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_gemini.R
\name{gemini_embedding}
\alias{gemini_embedding}
\title{Generate Embeddings Using the Google Gemini API}
\usage{
gemini_embedding(
  .input,
  .model = "text-embedding-004",
  .truncate = TRUE,
  .timeout = 120,
  .dry_run = FALSE,
  .max_tries = 3
)
}
\arguments{
\item{.input}{A character vector of texts to embed or an \code{LLMMessage} object}

\item{.model}{The embedding model identifier (default: "text-embedding-3-small").}

\item{.truncate}{Whether to truncate inputs to fit the model's context length (default: TRUE).}

\item{.timeout}{Timeout for the API request in seconds (default: 120).}

\item{.dry_run}{If TRUE, perform a dry run and return the request object.}

\item{.max_tries}{Maximum retry attempts for requests (default: 3).}
}
\value{
A matrix where each column corresponds to the embedding of a message in the message history.
}
\description{
Generate Embeddings Using the Google Gemini API
}
