% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{initialize_topic_counts}
\alias{initialize_topic_counts}
\title{Initialize topic counts for gibbs sampling}
\usage{
initialize_topic_counts(
  dtm,
  k,
  alpha,
  eta,
  beta_initial = NULL,
  theta_initial = NULL,
  freeze_topics = FALSE,
  threads = 1,
  ...
)
}
\arguments{
\item{dtm}{a document term matrix or term co-occurrence matrix of class \code{dgCMatrix}.}

\item{k}{the number of topics}

\item{alpha}{the numeric vector prior for topics over documents as formatted
by \code{\link[tidylda]{format_alpha}}}

\item{eta}{the numeric matrix prior for topics over documents as formatted
by \code{\link[tidylda]{format_eta}}}

\item{beta_initial}{if specified, a numeric matrix for the probability of tokens
in topics. Must be specified for predictions or updates as called by
\code{\link[tidylda]{predict.tidylda}} or \code{\link[tidylda]{refit.tidylda}}
respectively.}

\item{theta_initial}{if specified, a numeric matrix for the probability of
topics in documents. Must be specified for updates as called by
\code{\link[tidylda]{refit.tidylda}}}

\item{freeze_topics}{if \code{TRUE} does not update counts of tokens in topics.
This is \code{TRUE} for predictions.}

\item{threads}{number of parallel threads, currently unused}

\item{...}{Additional arguments, currently unused}
}
\value{
Returns a list with 5 elements: \code{docs}, \code{Zd}, \code{Cd}, \code{Cv},
  and \code{Ck}. All of these are used by \code{\link[tidylda]{fit_lda_c}}.

  \code{docs} is a list with one element per document. Each element is a vector
  of integers of length \code{sum(dtm[j,])} for the j-th document. The integer
  entries correspond to the zero-index column of the \code{dtm}.

  \code{Zd} is a list of similar format as \code{docs}. The difference is that
  the integer values correspond to the zero-index for topics.

  \code{Cd} is a matrix of integers denoting how many times each topic has
  been sampled in each document.

  \code{Cv} is similar to \code{Cd} but it counts how many times each topic
  has been sampled for each token.

  \code{Ck} is an integer vector denoting how many times each topic has been
  sampled overall.
}
\description{
Implementing seeded (or guided) LDA models and transfer learning means that
  we can't initialize topics with a uniform-random start. This function prepares
  data and then calls a C++ function, \code{\link[tidylda]{create_lexicon}}, that runs a single
  Gibbs iteration to populate topic counts (and other objects) used during the
  main Gibbs sampling run of \code{\link[tidylda]{fit_lda_c}}. In the event that
  you aren't using fancy seeding or transfer learning, this makes a random
  initialization by sampling from Dirichlet distributions parameterized by
  priors \code{alpha} and \code{eta}.
}
\note{
All of \code{Cd}, \code{Cv}, and \code{Ck} should be derivable by summing
  over Zd in various ways.
}
\keyword{internal}
