% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.tidylda.R
\name{posterior}
\alias{posterior}
\alias{posterior.tidylda}
\alias{generate.tidylda_posterior}
\title{Draw from the marginal posteriors of a tidylda topic model}
\usage{
posterior(x, ...)

\method{posterior}{tidylda}(x, ...)

\method{generate}{tidylda_posterior}(x, matrix, which, times, ...)
}
\arguments{
\item{x}{For \code{posterior}, an object of class
\code{tidylda}. For \code{generate}, an object of class
\code{tidylda_posterior} obtained by a call to \code{posterior}.}

\item{...}{Other arguments, currently not used.}

\item{matrix}{A character of either 'theta' or 'beta', indicating from which
matrix to draw posterior samples.}

\item{which}{Row index of \code{theta}, for document, or \code{beta}, for
topic, from which to draw samples. \code{which} may also be a vector of
indices.}

\item{times}{Integer number of samples to draw.}
}
\value{
\code{posterior} returns an object of class \code{tidylda_posterior}.

\code{generate} returns a tibble with one row per parameter per sample.

Returns a data frame where each row is a single sample from the posterior. 
Each column is the distribution over a single parameter. The variable \code{var}
is a facet for subsetting by document (for theta) or topic (for beta).
}
\description{
These functions are used to sample from the marginal posteriors
  of a \code{tidylda} topic model. This is useful for quantifying uncertainty
  around the parameters of \code{beta} or \code{theta}.
}
\details{
To sample from the marginal posteriors of a model, you must first make a call
to \code{posterior} and then a call to \code{generate}.

\code{posterior} takes an object of class \code{tidylda} and constructs an
object of class \code{tidylda_posterior} which contains two matrices. The rows
of these matrices are Dirichlet parameters used to sample from the marginal
posteriors of \code{theta} and \code{beta}.

\code{generate} takes an object of class \code{tidylda_posterior} and samples
from the marginal posterior of the parameters specified by the \code{matrix}
argument.
}
\examples{
\donttest{
# load some data
data(nih_sample_dtm, package = "textmineR")

# fit a model
set.seed(12345)

m <- tidylda(
  data = nih_sample_dtm[1:20, ], k = 5,
  iterations = 200, burnin = 175
)

# construct a posterior object
p <- posterior(m)

# sample from the marginal posterior corresponding to topic 1
t1 <- generate(
  x = p,
  matrix = "beta",
  which = 1,
  times = 100  
)

# sample from the marginal posterior corresponding to document 5
d5 <- generate(
  x = p,
  matrix = "theta",
  which = 5,
  times = 100
)
}
}
\references{
Heinrich, G. (2005) Parameter estimation for text analysis. Technical report. 
\href{http://www.arbylon.net/publications/text-est.pdf}{http://www.arbylon.net/publications/text-est.pdf}
}
