% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_values.R
\name{append_values}
\alias{append_values}
\alias{append_values_string}
\alias{append_values_number}
\alias{append_values_logical}
\title{Appends all JSON values with a specified type as a new column}
\usage{
append_values_string(.x, column.name = type, force = TRUE,
  recursive = FALSE)

append_values_number(.x, column.name = type, force = TRUE,
  recursive = FALSE)

append_values_logical(.x, column.name = type, force = TRUE,
  recursive = FALSE)
}
\arguments{
\item{.x}{a json string or \code{\link{tbl_json}} object}

\item{column.name}{the name of the column to append values as}

\item{force}{should values be coerced to the appropriate type
when possible, otherwise, types are checked first (requires more
memory)}

\item{recursive}{logical indicating whether to recurisvely extract a single
value from a nested object. Only used when \code{force = TRUE}. If
\code{force = FALSE}, and \code{recursive = TRUE}, throws an error.}
}
\value{
a \code{\link{tbl_json}} object
}
\description{
The \code{append_values} functions let you take any scalar JSON values
of a given type ("string", "number", "logical") and add them as a new
column named \code{column.name}. This is particularly useful after using
\code{\link{gather_object}} to gather an object.
}
\details{
Any values that can not be converted to the specified will be \code{NA} in
the resulting column. This includes other scalar types (e.g., numbers or
logicals if you are using \code{append_values_string}) and *also* any rows
where the JSON is NULL or an object or array.

Note that the \code{append_values} functions do not alter the JSON
attribute of the \code{tbl_json} object in any way.
}
\examples{

# Stack names
'{"first": "bob", "last": "jones"}' \%>\%
  gather_object \%>\%
  append_values_string

# This is most useful when data is stored in name-value pairs
# For example, tags in recipes:
recipes <- c('{"name": "pie", "tags": {"apple": 10, "pie": 2, "flour": 5}}',
             '{"name": "cookie", "tags": {"chocolate": 2, "cookie": 1}}')
recipes \%>\%
  spread_values(name = jstring(name)) \%>\%
  enter_object(tags) \%>\%
  gather_object("tag") \%>\%
  append_values_number("count")
}
\seealso{
\code{\link{gather_object}} to gather an object first,
   \code{\link{spread_all}} to spread values into new columns
}
