% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_plot.R, R/realtime_plot.R
\name{plot}
\alias{plot}
\alias{plot.hy}
\alias{plot.realtime}
\title{Plot historical and realtime data}
\usage{
\method{plot}{hy}(x = NULL, ...)

\method{plot}{realtime}(x = NULL, Parameter = c("Flow", "Level"), ...)
}
\arguments{
\item{x}{Object created by either a hy_daily_* or realtime_dd data retrieval function}

\item{...}{passed to \code{plot}}

\item{Parameter}{Parameter of interest. Either "Flow" or "Level". Defaults to "Flow".}
}
\description{
This method plots either daily time series data from HYDAT or realtime data from
the datamart. These plots are intended to be convenient and quick methods to 
visualize hydrometric data.
}
\section{Methods (by class)}{
\itemize{
\item \code{realtime}: plot.realtime
}}

\examples{
\dontrun{
# One station
fraser <- hy_daily_flows("08MF005")
plot(fraser)
}

\dontrun{
# One station
fraser_realtime <- realtime_dd("08MF005")
plot(fraser_realtime)
}

}
