% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_stn_.R
\name{hy_stn_data_coll}
\alias{hy_stn_data_coll}
\title{Extract station data collection from HYDAT database}
\format{A tibble with 6 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{DATA_TYPE_EN}{The type of data}
  \item{YEAR_FROM}{First year of use}
  \item{YEAR_TO}{Last year of use}
  \item{MEASUREMENT_CODE_EN}{Either 1) the sampling method used in the collection of 
  sediment data or 2) the type of the gauge used in the collection of the hydrometric data}
  \item{OPERATION_CODE_EN}{The schedule of station operation 
  for the collection of sediment or hydrometric data}
}}
\source{
HYDAT
}
\usage{
hy_stn_data_coll(station_number = NULL, hydat_path = NULL,
  prov_terr_state_loc = NULL)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The default for this argument is to look for hydat in the same location where it
was saved by using \code{download_hydat}. Therefore this argument is almost always omitted from a function call. 
You can see where hydat was downloaded using \code{hy_dir()}}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}}
}
\value{
A tibble of hy_stn_data_coll
}
\description{
hy_stn_data_coll look-up Table
}
\examples{
\dontrun{
hy_stn_data_coll(station_number = c("02JE013","08MF005"))
}

}
\seealso{
Other HYDAT functions: \code{\link{hy_agency_list}},
  \code{\link{hy_annual_instant_peaks}},
  \code{\link{hy_annual_stats}},
  \code{\link{hy_daily_flows}},
  \code{\link{hy_daily_levels}},
  \code{\link{hy_data_symbols}},
  \code{\link{hy_data_types}}, \code{\link{hy_datum_list}},
  \code{\link{hy_monthly_flows}},
  \code{\link{hy_monthly_levels}},
  \code{\link{hy_reg_office_list}},
  \code{\link{hy_sed_daily_loads}},
  \code{\link{hy_sed_daily_suscon}},
  \code{\link{hy_sed_monthly_loads}},
  \code{\link{hy_sed_monthly_suscon}},
  \code{\link{hy_sed_samples_psd}},
  \code{\link{hy_sed_samples}}, \code{\link{hy_stations}},
  \code{\link{hy_stn_data_range}},
  \code{\link{hy_stn_op_schedule}},
  \code{\link{hy_stn_regulation}}, \code{\link{hy_version}}
}
