% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_monthly_flows.R
\name{hy_monthly_flows}
\alias{hy_monthly_flows}
\title{Extract monthly flows information from the HYDAT database}
\format{A tibble with 8 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{YEAR}{Year of record.}
  \item{MONTH}{Numeric month value}
  \item{FULL_MONTH}{Logical value is there is full record from MONTH}
  \item{NO_DAYS}{Number of days in that month}
  \item{Sum_stat}{Summary statistic being used.} 
  \item{Value}{Value of the measurement in m^3/s.}
  \item{Date_occurred}{Observation date. Formatted as a Date class. MEAN is a annual summary 
  and therefore has an NA value for Date.}
}}
\source{
HYDAT
}
\usage{
hy_monthly_flows(station_number = NULL, hydat_path = NULL,
  prov_terr_state_loc = NULL, start_date = "ALL", end_date = "ALL")
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The default for this argument is to look for hydat in the same location where it
was saved by using \code{download_hydat}. Therefore this argument is almost always omitted from a function call. 
You can see where hydat was downloaded using \code{hy_dir()}}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}}

\item{start_date}{Leave blank if all dates are required. Date format needs to be in YYYY-MM-DD. Date is inclusive.}

\item{end_date}{Leave blank if all dates are required. Date format needs to be in YYYY-MM-DD. Date is inclusive.}
}
\value{
A tibble of monthly flows.
}
\description{
Tidy data of monthly flows information from the DLY_FLOWS HYDAT table. \code{station_number} and
\code{prov_terr_state_loc} can both be supplied. If both are omitted all values from the \code{hy_stations} table are returned.
That is a large vector for \code{hy_monthly_flows}.
}
\examples{
\dontrun{
hy_monthly_flows(station_number = c("02JE013","08MF005"), 
  start_date = "1996-01-01", end_date = "2000-01-01")

hy_monthly_flows(prov_terr_state_loc = "PE")
          }
          
}
\seealso{
Other HYDAT functions: \code{\link{hy_agency_list}},
  \code{\link{hy_annual_instant_peaks}},
  \code{\link{hy_annual_stats}},
  \code{\link{hy_daily_flows}},
  \code{\link{hy_daily_levels}},
  \code{\link{hy_data_symbols}},
  \code{\link{hy_data_types}}, \code{\link{hy_datum_list}},
  \code{\link{hy_monthly_levels}},
  \code{\link{hy_reg_office_list}},
  \code{\link{hy_sed_daily_loads}},
  \code{\link{hy_sed_daily_suscon}},
  \code{\link{hy_sed_monthly_loads}},
  \code{\link{hy_sed_monthly_suscon}},
  \code{\link{hy_sed_samples_psd}},
  \code{\link{hy_sed_samples}}, \code{\link{hy_stations}},
  \code{\link{hy_stn_data_coll}},
  \code{\link{hy_stn_data_range}},
  \code{\link{hy_stn_op_schedule}},
  \code{\link{hy_stn_regulation}}, \code{\link{hy_version}}
}
