% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{sampling_games}
\alias{sampling_games}
\alias{play_degree}
\alias{play_dotprod}
\alias{play_fitness}
\alias{play_fitness_power}
\alias{play_erdos_renyi}
\alias{play_geometry}
\title{Graph games based on direct sampling}
\usage{
play_degree(out_degree, in_degree = NULL, method = "simple")

play_dotprod(position, directed = TRUE)

play_fitness(m, out_fit, in_fit = NULL, loops = FALSE, multiple = FALSE)

play_fitness_power(n, m, out_exp, in_exp = -1, loops = FALSE,
  multiple = FALSE, correct = TRUE)

play_erdos_renyi(n, p, m, directed = TRUE, loops = FALSE)

play_geometry(n, radius, torus = FALSE)
}
\arguments{
\item{out_degree, in_degree}{The degrees of each node in the graph}

\item{method}{The algorithm to use for the generation. Either \code{'simple'},
\code{'vl'}, or \code{'simple.no.multiple'}}

\item{position}{The latent position of each node by column.}

\item{directed}{Should the resulting graph be directed}

\item{m}{The number of edges in the graph}

\item{out_fit, in_fit}{The fitness of each node}

\item{loops}{Are loop edges allowed}

\item{multiple}{Are multiple edges allowed}

\item{n}{The number of nodes in the graph.}

\item{out_exp, in_exp}{Power law exponent of degree distribution}

\item{correct}{Use finite size correction}

\item{p}{The probabilty of an edge occuring}

\item{radius}{The radius within which vertices are connected}

\item{torus}{Should the vertices be distributed on a torus instead of a plane}
}
\value{
A tbl_graph object
}
\description{
This set of graph games creates graphs directly through sampling of different
attributes, topologies, etc. The nature of their algorithm is described in
detail at the linked igraph documentation.
}
\section{Functions}{
\itemize{
\item \code{play_degree}: Create graphs based on the given node degrees. See
\code{\link[igraph:sample_degseq]{igraph::sample_degseq()}}

\item \code{play_dotprod}: Create graphs with link probability given by the
dot product of the latent position of termintating nodes. See
\code{\link[igraph:sample_dot_product]{igraph::sample_dot_product()}}

\item \code{play_fitness}: Create graphs where edge probabilities are
proportional to terminal node fitness scores. See \code{\link[igraph:sample_fitness]{igraph::sample_fitness()}}

\item \code{play_fitness_power}: Create graphs with an expected power-law degree
distribution. See \code{\link[igraph:sample_fitness_pl]{igraph::sample_fitness_pl()}}

\item \code{play_erdos_renyi}: Create graphs with a fixed edge probability or
count. See \code{\link[igraph:sample_gnp]{igraph::sample_gnp()}} and \code{\link[igraph:sample_gnm]{igraph::sample_gnm()}}

\item \code{play_geometry}: Create graphs by positioning nodes on a plane or
torus and connecting nearby ones. See \code{\link[igraph:sample_grg]{igraph::sample_grg()}}
}}

\examples{
plot(play_erdos_renyi(20, 0.3))
}
\seealso{
Other graph games: \code{\link{component_games}},
  \code{\link{evolution_games}}, \code{\link{type_games}}
}
