% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activate.R
\name{activate}
\alias{activate}
\alias{active}
\title{Determine the context of subsequent manipulations}
\usage{
activate(.data, what)

active(x)
}
\arguments{
\item{.data, x}{A tbl_graph or a grouped_tbl_graph}

\item{what}{What should get activated? Possible values are \code{nodes} or
\code{edges}.}
}
\value{
A tbl_graph
}
\description{
As a \link{tbl_graph} can be considered as a collection of two linked tables it is
necessary to specify which table is referenced during manipulations. The
\code{activate} verb does just that and needs affects all subsequent manipulations
until a new table is activated. \code{active} is a simple query function to get
the currently acitve context.
}
\note{
Activate will ungroup a grouped_tbl_graph.
}
\examples{
gr <- create_complete(5) \%>\%
  activate(nodes) \%>\%
  mutate(class = sample(c('a', 'b'), 5, TRUE)) \%>\%
  activate(edges) \%>\%
  arrange(from)

}
