% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_dt.R
\name{select_dt}
\alias{select_dt}
\alias{select_mix}
\title{Select column from data.frame}
\usage{
select_dt(.data, ..., cols = NULL, negate = FALSE)

select_mix(.data, ..., rm.dup = TRUE)
}
\arguments{
\item{.data}{data.frame}

\item{...}{List of variables or name-value pairs of summary/modifications
functions. It can also recieve conditional function to select columns.
When starts with `-`(minus symbol) or `!`, return the negative columns.}

\item{cols}{(Optional)A numeric or character vector.}

\item{negate}{Applicable when regular expression and "cols" is used.
If \code{TRUE}, return the non-matched pattern. Default uses \code{FALSE}.}

\item{rm.dup}{Should duplicated columns be removed? Defaults to \code{TRUE}.}
}
\value{
data.table
}
\description{
Analogous function for \code{select} and \code{select_if} in \pkg{dplyr}.
}
\examples{
iris \%>\% select_dt(Species)
iris \%>\% select_dt(Sepal.Length,Sepal.Width)
iris \%>\% select_dt(Sepal.Length:Petal.Length)
iris \%>\% select_dt(-Sepal.Length)
iris \%>\% select_dt(-Sepal.Length,-Petal.Length)
iris \%>\% select_dt(-(Sepal.Length:Petal.Length))
iris \%>\% select_dt(c("Sepal.Length","Sepal.Width"))
iris \%>\% select_dt(1)
iris \%>\% select_dt(-1)
iris \%>\% select_dt(1:3)
iris \%>\% select_dt(-(1:3))
iris \%>\% select_dt(1,3)
iris \%>\% select_dt("Pe")
iris \%>\% select_dt(-"Se")
iris \%>\% select_dt(!"Se")
iris \%>\% select_dt("Pe",negate = TRUE)
iris \%>\% select_dt("Pe|Sp")
iris \%>\% select_dt(cols = 2:3)
iris \%>\% select_dt(cols = 2:3,negate = TRUE)
iris \%>\% select_dt(cols = names(iris)[2:3])

iris \%>\% select_dt(is.factor)
iris \%>\% select_dt(-is.factor)

# select_mix could provide flexible mix selection
select_mix(iris, Species,"Sepal.Length")
select_mix(iris,1:2,is.factor)

select_mix(iris,Sepal.Length,is.numeric)
# set rm.dup to FALSE could save the duplicated column names
select_mix(iris,Sepal.Length,is.numeric,rm.dup = FALSE)
}
\seealso{
\code{\link[dplyr]{select}}, \code{\link[dplyr]{select_if}}
}
