% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_dt.R
\name{nest_dt}
\alias{nest_dt}
\alias{unnest_dt}
\alias{squeeze_dt}
\alias{chop_dt}
\alias{unchop_dt}
\title{Nest and unnest}
\usage{
nest_dt(data, ..., mcols = NULL)

unnest_dt(data, ...)

squeeze_dt(data, ...)

chop_dt(data, ...)

unchop_dt(data, ...)
}
\arguments{
\item{data}{data.table, nested or unnested}

\item{...}{The variables for nest group(for \code{nest_dt}),
columns to be nested(for \code{squeeze_dt} and \code{chop_dt}),
or column(s) to be unnested(for \code{unnest_dt}).
Could recieve anything that \code{\link[tidyfst]{select_dt}} could receive.}

\item{mcols}{Name-variable pairs in the list, form like
\code{list(petal="^Pe",sepal="^Se")}, see example.}
}
\value{
data.table, nested or unnested
}
\description{
Analogous function for \code{nest} and \code{unnest} in \pkg{tidyr}.
\code{unnest_dt} will automatically remove other list-columns except for the
target list-columns (which would be unnested later). Also, \code{squeeze_dt} is
designed to merge multiple columns into list column.
}
\details{
In the \code{nest_dt}, the data would be nested to a column named `ndt`,
 which is short for nested data.table.

The \code{squeeze_dt} would not remove the originial columns.

The \code{unchop_dt} is the reverse operation of \code{chop_dt}.

These functions are experiencing the experimental stage, especially
the \code{unnest_dt}. If they don't work on some circumtances, try \pkg{tidyr}
package.
}
\examples{

# examples for nest_dt
# nest by which columns?
 mtcars \%>\% nest_dt(cyl)
 mtcars \%>\% nest_dt("cyl")
 mtcars \%>\% nest_dt(cyl,vs)
 mtcars \%>\% nest_dt(vs:am)
 mtcars \%>\% nest_dt("cyl|vs")
 mtcars \%>\% nest_dt(c("cyl","vs"))

# nest two columns directly
iris \%>\% nest_dt(mcols = list(petal="^Pe",sepal="^Se"))

# examples for unnest_dt
# unnest which column?
 mtcars \%>\% nest_dt("cyl|vs") \%>\%
   unnest_dt(ndt)
 mtcars \%>\% nest_dt("cyl|vs") \%>\%
   unnest_dt("ndt")

df <- data.table(
  a = list(c("a", "b"), "c"),
  b = list(c(TRUE,TRUE),FALSE),
  c = list(3,c(1,2)),
  d = c(11, 22)
)

df
df \%>\% unnest_dt(a)
df \%>\% unnest_dt(2)
df \%>\% unnest_dt("c")
df \%>\% unnest_dt(cols = names(df)[3])

# You can unnest multiple columns simultaneously
df \%>\% unnest_dt(1:3)
df \%>\% unnest_dt(a,b,c)
df \%>\% unnest_dt("a|b|c")

# examples for squeeze_dt
# nest which columns?
iris \%>\% squeeze_dt(1:2)
iris \%>\% squeeze_dt("Se")
iris \%>\% squeeze_dt(Sepal.Length:Petal.Width)

# examples for chop_dt
df <- data.table(x = c(1, 1, 1, 2, 2, 3), y = 1:6, z = 6:1)
df \%>\% chop_dt(y,z)
df \%>\% chop_dt(y,z) \%>\% unchop_dt(y,z)
}
\references{
https://www.r-bloggers.com/much-faster-unnesting-with-data-table/

https://stackoverflow.com/questions/25430986/create-nested-data-tables-by-collapsing-rows-into-new-data-tables
}
\seealso{
\code{\link[tidyr]{nest}}, \code{\link[tidyr]{chop}}
}
