% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_dt.R
\name{group_dt}
\alias{group_dt}
\title{Data manipulation within groups}
\usage{
group_dt(data, by = NULL, ...)
}
\arguments{
\item{data}{data.frame}

\item{by}{Variables to group by,unquoted name of grouping variable of list of unquoted names of grouping variables.}

\item{...}{Any data manipulation arguments that could be implemented on a data.frame.}
}
\value{
data.table
}
\description{
Analogous function for \code{group_by} in \pkg{dplyr},
but in another efficient way.
}
\examples{
iris \%>\% group_dt(by = Species,slice_dt(1:2))
iris \%>\% group_dt(Species,filter_dt(Sepal.Length == max(Sepal.Length)))
iris \%>\% group_dt(Species,summarise_dt(new = max(Sepal.Length)))

# you can pipe in the `group_dt`
iris \%>\% group_dt(Species,
                  mutate_dt(max= max(Sepal.Length)) \%>\%
                    summarise_dt(sum=sum(Sepal.Length)))

# for summarise_dt, you can use "by" to calculate within the group
mtcars \%>\%
  summarise_dt(
   disp = mean(disp),
   hp = mean(hp),
   by = cyl
)

 # but you could also, of course, use group_dt
mtcars \%>\%
  group_dt(by =.(vs,am),
    summarise_dt(avg = mean(mpg)))

}
