% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalize.R
\name{finalize_model_tidyclust}
\alias{finalize_model_tidyclust}
\alias{finalize_workflow_tidyclust}
\title{Splice final parameters into objects}
\usage{
finalize_model_tidyclust(x, parameters)

finalize_workflow_tidyclust(x, parameters)
}
\arguments{
\item{x}{A recipe, \code{parsnip} model specification, or workflow.}

\item{parameters}{A list or 1-row tibble of parameter values. Note that the
column names of the tibble should be the \code{id} fields attached to \code{tune()}.
For example, in the \code{Examples} section below, the model has \code{tune("K")}. In
this case, the parameter tibble should be "K" and not "neighbors".}
}
\value{
An updated version of \code{x}.
}
\description{
The \verb{finalize_*} functions take a list or tibble of tuning parameter values
and update objects with those values.
}
\examples{
kmeans_spec <- k_means(num_clusters = tune())
kmeans_spec

best_params <- data.frame(num_clusters = 5)
best_params

finalize_model_tidyclust(kmeans_spec, best_params)
}
