% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-sse.R
\name{sse_ratio}
\alias{sse_ratio}
\alias{sse_ratio.cluster_fit}
\alias{sse_ratio.workflow}
\alias{sse_ratio_vec}
\title{Compute the ratio of the WSS to the total SSE}
\usage{
sse_ratio(object, ...)

\method{sse_ratio}{cluster_fit}(object, new_data = NULL, dist_fun = NULL, ...)

\method{sse_ratio}{workflow}(object, new_data = NULL, dist_fun = NULL, ...)

sse_ratio_vec(object, new_data = NULL, dist_fun = Rfast::dista, ...)
}
\arguments{
\item{object}{A fitted kmeans tidyclust model}

\item{...}{Other arguments passed to methods.}

\item{new_data}{A dataset to predict on.  If \code{NULL}, uses trained clustering.}

\item{dist_fun}{A function for calculating distances to centroids.  Defaults
to Euclidean distance on processed data.}
}
\value{
A tibble with 3 columns; \code{.metric}, \code{.estimator}, and \code{.estimate}.
}
\description{
Compute the ratio of the WSS to the total SSE
}
\examples{
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

sse_ratio(kmeans_fit)

sse_ratio_vec(kmeans_fit)
}
\seealso{
Other cluster metric: 
\code{\link{silhouette_avg}()},
\code{\link{sse_total}()},
\code{\link{sse_within_total}()}
}
\concept{cluster metric}
