% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/class-mod_cpt.R,
%   R/class-seg_basket.R, R/class-seg_cpt.R, R/class-tidycpt.R, R/pkg-GA.R,
%   R/pkg-changepoint.R, R/pkg-wbs.R
\name{model_name}
\alias{model_name}
\alias{model_name.default}
\alias{model_name.character}
\alias{model_name.mod_cpt}
\alias{model_name.seg_basket}
\alias{model_name.seg_cpt}
\alias{model_name.tidycpt}
\alias{model_name.ga}
\alias{model_name.cpt}
\alias{model_name.wbs}
\title{Retrieve the name of the model that a segmenter or model used}
\usage{
model_name(object, ...)

\method{model_name}{default}(object, ...)

\method{model_name}{character}(object, ...)

\method{model_name}{mod_cpt}(object, ...)

\method{model_name}{seg_basket}(object, ...)

\method{model_name}{seg_cpt}(object, ...)

\method{model_name}{tidycpt}(object, ...)

\method{model_name}{ga}(object, ...)

\method{model_name}{cpt}(object, ...)

\method{model_name}{wbs}(object, ...)
}
\arguments{
\item{object}{A \code{segmenter} object.}

\item{...}{currently ignored}
}
\value{
A \code{character} vector of length 1.
}
\description{
Retrieve the name of the model that a segmenter or model used
}
\details{
Every segmenter works by fitting a model to the data. \code{\link[=model_name]{model_name()}} returns
the name of a model that can be passed to \code{\link[=whomademe]{whomademe()}} to retrieve the
model fitting function. These functions must begin with the prefix \code{fit_}.
Note that the model fitting functions exist in \code{tidychangepoint} are are
not necessarily the actual functions used by the segmenter.

Models also implement \code{model_name()}.
}
\examples{
# Segment a time series using PELT
x <- segment(CET, method = "pelt")

# Retrieve the name of the model from the segmenter
x |>
  as.segmenter() |>
  model_name()

# What function created the model? 
x |>
  model_name() |>
  whomademe()
model_name(x$segmenter)

# Retrieve the name of the model from the model
x |>
  as.model() |>
  model_name()
  
}
\seealso{
Other model-fitting: 
\code{\link{fit_lmshift}()},
\code{\link{fit_meanshift}()},
\code{\link{fit_meanvar}()},
\code{\link{fit_nhpp}()},
\code{\link{model_args}()},
\code{\link{new_fun_cpt}()},
\code{\link{whomademe}()}

Other tidycpt-generics: 
\code{\link{as.model}()},
\code{\link{as.segmenter}()},
\code{\link{changepoints}()},
\code{\link{diagnose}()},
\code{\link{fitness}()}
}
\concept{model-fitting}
\concept{tidycpt-generics}
