% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-mod_cpt.R
\name{new_mod_cpt}
\alias{new_mod_cpt}
\alias{validate_mod_cpt}
\alias{mod_cpt}
\title{Base class for changepoint models}
\usage{
new_mod_cpt(
  x = numeric(),
  tau = integer(),
  region_params = tibble::tibble(),
  model_params = double(),
  fitted_values = double(),
  model_name = character(),
  ...
)

validate_mod_cpt(x)

mod_cpt(x, ...)
}
\arguments{
\item{x}{a numeric vector coercible into a \code{ts} object}

\item{tau}{indices of the changepoint set}

\item{region_params}{A \code{\link[tibble:tibble]{tibble::tibble()}} with one row for each region
defined by the changepoint set \code{tau}. Each variable represents a parameter
estimated in that region.}

\item{model_params}{A numeric vector of parameters estimated by the model
across the entire data set (not just in each region).}

\item{fitted_values}{Fitted values returned by the model on the original
data set.}

\item{model_name}{A \code{character} vector giving the model's name.}

\item{...}{currently ignored}
}
\value{
A \link{mod_cpt} object
}
\description{
Create changepoint detection model objects
}
\details{
Changepoint detection models know how they were created, on what data set,
about the optimal changepoint set found, and the parameters that were fit
to the model.
Methods for various generic reporting functions are provided.

All changepoint detection models inherit from \link{mod_cpt}: the
base class for changepoint detection models.
These models are created by one of the \verb{fit_*()} functions, or by
\code{\link[=as.model]{as.model()}}.
}
\examples{
cpt <- mod_cpt(CET)
str(cpt)
as.ts(cpt)
changepoints(cpt)
}
\seealso{
\code{\link[=as.model]{as.model()}}
}
