% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/class-mod_cpt.R,
%   R/class-seg_basket.R, R/class-tidycpt.R, R/mod_nhpp.R
\name{diagnose}
\alias{diagnose}
\alias{diagnose.mod_cpt}
\alias{diagnose.seg_basket}
\alias{diagnose.tidycpt}
\alias{diagnose.nhpp}
\title{Diagnose the fit of a segmented time series}
\usage{
diagnose(x, ...)

\method{diagnose}{mod_cpt}(x, ...)

\method{diagnose}{seg_basket}(x, ...)

\method{diagnose}{tidycpt}(x, ...)

\method{diagnose}{nhpp}(x, ...)
}
\arguments{
\item{x}{A \linkS4class{tidycpt} object, or a \code{model} or \code{segmenter}}

\item{...}{currently ignored}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Depending on the input, this function returns a diagnostic plot.
}
\examples{
# For meanshift models, show the distribution of the residuals by region
fit_meanshift_norm(CET, tau = 330) |>
  diagnose()
\donttest{
# For Coen's algorithm, show the histogram of changepoint selections
x <- segment(DataCPSim, method = "coen", num_generations = 3)
x |>
  as.segmenter() |>
  diagnose()
}

# Show various iterations of diagnostic plots
diagnose(segment(DataCPSim))
diagnose(segment(DataCPSim, method = "single-best"))
diagnose(segment(DataCPSim, method = "pelt"))

# Show diagnostic plots for test sets
diagnose(segment(test_set()))
diagnose(segment(test_set(n = 2, sd = 4), method = "pelt"))

# For NHPP models, show the growth in the number of exceedances
diagnose(fit_nhpp(DataCPSim, tau = 826))
diagnose(fit_nhpp(DataCPSim, tau = 826, threshold = 200))

}
\seealso{
Other tidycpt-generics: 
\code{\link{as.model}()},
\code{\link{as.segmenter}()},
\code{\link{changepoints}()},
\code{\link{fitness}()},
\code{\link{model_name}()}
}
\concept{tidycpt-generics}
