% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cell_df.R
\name{cell_df-class}
\alias{cell_df-class}
\title{\code{cell_df} class}
\description{
The \code{cell_df} class is a subclass of \code{\link[tibble:tibble]{tbl_df}} and \code{\link[base:data.frame]{data.frame}},
created in order to store cell level information.
}
\section{Properties of \code{cell_df}}{


Objects of class \code{cell_df} have:
\itemize{
\item A \code{class} attribute of \code{c("cell_df", "cells", "rc_df", "tbl_df", "tbl", "data.frame")}.
\item Two column of \code{integer} type named \code{row} and \code{col}. All entries must be positive and not \code{NA}.
This represents a cell address.
\item A column of \code{character} type named \code{data_type}. Which can contain only \code{numeric} or \code{character} as entries.
This represents the data type of the cell (classified to only two categories).
\item A column of \code{character} type named \code{value}. This stores value of corresponding cells.
\item Apart from these columns it can contain other columns.
However, (\code{row}, \code{col}) together should identify the row of the \code{cell_df} uniquely.
}
}

\section{Applicable methods on \code{cell_df}}{

\itemize{
\item \code{print}: Prints identifier of the class and the content of the underlying tibble.
\item \code{summary}: Calculates basic stats like number of rows and columns, number of characters and numeric fields, density etc.
\item \code{plot}: Plots (using \code{\link[ggplot2:ggplot]{ggplot2}}) the cell information as ordinary table.
\item \code{as.matrix}: This will transform the data back into tabular form and create a character matrix.
\item \code{as.data.frame}: Similar to \code{as.matrix} this will also transform the data back into tabular form.
}
}

\seealso{
The function \code{\link[=validate_cells]{validate_cells}} which is used to validate \code{cell_df}.

The \code{as.matrix} and \code{as.data.frame} method is similar to \code{\link[unpivotr:rectify]{unpivotr::rectify}}.

Object of this class is also compatible to most of the functions from \code{\link[unpivotr:unpivotr-package]{unpivotr}} package.
}
\keyword{internal}
