% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lkjcorr_marginal.R
\name{lkjcorr_marginal}
\alias{lkjcorr_marginal}
\alias{dlkjcorr_marginal}
\alias{plkjcorr_marginal}
\alias{qlkjcorr_marginal}
\alias{rlkjcorr_marginal}
\title{Marginal distribution of a single correlation from an LKJ distribution}
\usage{
dlkjcorr_marginal(x, K, eta, log = FALSE)

plkjcorr_marginal(q, K, eta, lower.tail = TRUE, log.p = FALSE)

qlkjcorr_marginal(p, K, eta, lower.tail = TRUE, log.p = FALSE)

rlkjcorr_marginal(n, K, eta)
}
\arguments{
\item{x}{vector of quantiles.}

\item{K}{Dimension of the correlation matrix. Must be greater than or equal to 2.}

\item{eta}{Parameter controlling the shape of the distribution}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}
}
\description{
Marginal distribution for the correlation in a single cell from a correlation
matrix distributed according to an LKJ distribution.
}
\details{
The LKJ distribution is a distribution over correlation matrices with a single parameter, \eqn{\eta}{eta}.
For a given \eqn{\eta}{eta} and a \eqn{K \times K}{KxK} correlation matrix \eqn{R}{R}:

\deqn{R \sim \textrm{LKJ}(\eta)}{R ~ LKJ(eta)}

Each off-diagonal entry of \eqn{R}{R}, \eqn{r_{ij}: i \ne j}{r[i,j]: i != j}, has the
following marginal distribution (Lewandowski, Kurowicka, and Joe 2009):

\deqn{\frac{r_{ij} + 1}{2} \sim \textrm{Beta}\left(\eta - 1 + \frac{K}{2}, \eta - 1 + \frac{K}{2}\right)
}{(r[i,j] + 1)/2 ~ Beta(eta - 1 + K/2, eta - 1 + K/2)}

In other words, \eqn{r_{ij}}{r[i,j]} is marginally distributed according to the above Beta
distribution scaled into \eqn{(-1,1)}{(-1,1)}.
}
\examples{

library(dplyr)
library(ggplot2)

data.frame(prior = "lkjcorr_marginal(2, 3)") \%>\%
  parse_dist(prior) \%>\%
  ggplot(aes(y = prior, dist = .dist, args = .args)) +
  stat_dist_halfeyeh() +
  xlim(-1, 1) +
  xlab("Marginal correlation for LKJ(3) prior on 2x2 correlation matrix")

}
\references{
Lewandowski, D., Kurowicka, D., & Joe, H. (2009). Generating random correlation matrices based on vines
and extended onion method. \emph{Journal of Multivariate Analysis}, 100(9), 1989--2001.
\doi{10.1016/j.jmva.2009.04.008}.
}
\seealso{
\code{\link[=parse_dist]{parse_dist()}} and \code{\link[=marginalize_lkjcorr]{marginalize_lkjcorr()}} for parsing specs that use the
LKJ correlation distribution and the \code{\link[=stat_dist_slabinterval]{stat_dist_slabinterval()}} family of stats for visualizing them.
}
