% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_draws.R
\name{tidy_draws}
\alias{tidy_draws}
\alias{tidy_draws.default}
\alias{tidy_draws.mcmc.list}
\alias{tidy_draws.stanfit}
\alias{tidy_draws.stanreg}
\alias{tidy_draws.runjags}
\alias{tidy_draws.jagsUI}
\alias{tidy_draws.brmsfit}
\alias{tidy_draws.matrix}
\alias{tidy_draws.MCMCglmm}
\title{Get a sample of posterior draws from a model as a tibble}
\usage{
tidy_draws(model)

\method{tidy_draws}{default}(model)

\method{tidy_draws}{mcmc.list}(model)

\method{tidy_draws}{stanfit}(model)

\method{tidy_draws}{stanreg}(model)

\method{tidy_draws}{runjags}(model)

\method{tidy_draws}{jagsUI}(model)

\method{tidy_draws}{brmsfit}(model)

\method{tidy_draws}{matrix}(model)

\method{tidy_draws}{MCMCglmm}(model)
}
\arguments{
\item{model}{A supported Bayesian model fit object. See \code{\link{tidybayes-models}} for a list of supported
models.}
}
\value{
A data frame (actually, a \code{\link[tibble]{tibble}}) with a \code{.chain} column,
\code{.iteration} column, \code{.draw} column, and one column for every variable in \code{model}.
}
\description{
Extract draws from a Bayesian fit into a wide-format data frame with a
\code{.chain}, \code{.iteration}, and \code{.draw} column, as well as all variables
as columns. While this function can be useful for quick glances at models (especially
combined with \code{\link{gather_variables}} and \code{\link{median_qi}}), it is
generally speaking not as useful as \code{\link{spread_draws}} or
\code{\link{gather_draws}} for most applications, and is mainly used internally (see `Details`).
}
\details{
In practice, apart from quick looks at a model you will probably not call this directly;
\code{\link{spread_draws}} or \code{\link{gather_draws}}, which are build on top of this
function, provide support for extracting variable dimensions are so are often more useful.

To provide support for new models in tidybayes,
you must provide an implementation of this function \emph{or} an implementation
of \code{\link[coda]{as.mcmc.list}} (\code{tidy_draws} should work on any model
with an implementation of \code{\link[coda]{as.mcmc.list}})
}
\examples{

library(magrittr)

data(line, package = "coda")

line \%>\%
  tidy_draws()

}
\seealso{
\code{\link{spread_draws}} or \code{\link{gather_draws}}, which use this function
internally and provides a friendly interface for extracting tidy data frames from model fits.
}
\author{
Matthew Kay
}
\keyword{manip}
