% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose_data.R
\name{n_prefix}
\alias{n_prefix}
\title{Prefix function generator for composing dimension index columns}
\usage{
n_prefix(prefix)
}
\arguments{
\item{prefix}{Character vector to be prepended to column names by
\code{\link{compose_data}} to create index columns. Typically something
like \code{"n"} (that is the default used in the \code{.n_name} argument
of \code{\link{compose_data}}).

Returns a function. The function returned takes a character vector, \code{name}
and returns \code{paste0(prefix, "_", name)}, unless \code{name} is empty, in
which case it will return \code{prefix}.

\code{n_prefix("n")} is the default method that \code{\link{compose_data}} uses to
generate column names for variables storing the number of levels in a factor. Under
this method, given a data frame
\code{df} with a factor column \code{"foo"} containing 5 levels, the results of
\code{compose_data(df)} will include an element named \code{"n"} (the result of
\code{n_prefix("n")("")}) equal to the number of rows in \code{df} and an element
named \code{"n_foo"} (the result of \code{n_prefix("n")("foo")}) equal to the
number of levels in \code{df$foo}.}
}
\description{
Generates a function for generating names of index columns for factors in
\code{\link{compose_data}} by prefixing a character vector to the original
column name.
}
\examples{

library(magrittr)

df = data.frame(
  plot = factor(paste0("p", rep(1:8, times = 2))),
  site = factor(paste0("s", rep(1:4, each = 2, times = 2)))
)

# without changing `.n_name`, compose_data() will prefix indices
# with "n" by default
df \%>\%
  compose_data()

# you can use n_prefix() to define a different prefix (e.g. "N"):
df \%>\%
  compose_data(.n_name = n_prefix("N"))

}
\seealso{
The \code{.n_name} argument of \code{\link{compose_data}}.
}
