# gather_emmeans_draws
#
# Author: mjskay
###############################################################################


# deprecated names for gather_emmeans_draws -----------------------------

#' @rdname tidybayes-deprecated
#' @format NULL
#' @usage NULL
#' @export
gather_lsmeans_samples = function(...) {
  .Deprecated("gather_emmeans_draws", package = "tidybayes") # nocov
  combine_chains_for_deprecated_(gather_emmeans_draws(..., value = "estimate")) # nocov
}

#' @rdname tidybayes-deprecated
#' @format NULL
#' @usage NULL
#' @export
gather_emmeans_samples = function(...) {
  .Deprecated("gather_emmeans_draws", package = "tidybayes") # nocov
  combine_chains_for_deprecated_(gather_emmeans_draws(..., value = "estimate")) # nocov
}



# gather_emmeans_draws -----------------------------

#' Extract a tidy data frame of draws of posterior distributions of "estimated marginal means" (emmeans/lsmeans) from
#' a Bayesian model fit.
#'
#' Extract draws from the result of a call to \code{\link[emmeans]{emmeans}} (formerly \code{lsmeans})
#' or \code{\link[emmeans]{ref_grid}} applied to a Bayesian model.
#'
#' \code{\link[emmeans]{emmeans}} provides a convenient syntax for generating draws from "estimated marginal means" from a model,
#' and can be applied to various Bayesian models, like \code{\link[rstanarm]{stanreg-objects}} and
#' \code{\link[MCMCglmm]{MCMCglmm}}. Given a \code{\link[emmeans]{ref_grid}} object as returned by functions like
#' \code{\link[emmeans]{ref_grid}} or \code{\link[emmeans]{emmeans}} applied to a Bayesian model,
#' \code{gather_emmeans_draws} returns a tidy format data frame of draws from
#' the marginal posterior distributions generated by \code{\link[emmeans]{emmeans}}.
#'
#' @param object An \code{emmGrid} object such as returned by
#' \code{\link[emmeans]{ref_grid}} or \code{\link[emmeans]{emmeans}}.
#' @param value The name of the output column to use to contain the values of draws. Defaults to \code{".value"}.
#'
#' @return A tidy data frame of draws. The columns of the reference grid are returned as-is, with an
#' additional column called \code{.value} (by default) containing marginal draws. The resulting data
#' frame is grouped by the columns from the reference grid to make use of summary functions like
#' \code{\link{point_interval}} straightforward.
#'
#' @author Matthew Kay
#' @seealso \code{\link[emmeans]{emmeans}}
#' @keywords manip
#' @examples
#'
#' library(dplyr)
#' library(magrittr)
#' library(rstanarm)
#' library(emmeans)
#'
#' # Here's an example dataset with a categorical predictor (`condition`) with several levels:
#' set.seed(5)
#' n = 10
#' n_condition = 5
#' ABC =
#'   data_frame(
#'     condition = rep(c("A","B","C","D","E"), n),
#'     response = rnorm(n * 5, c(0,1,2,1,-1), 0.5)
#'   )
#'
#' m = stan_glm(response ~ condition, data = ABC,
#'   # 1 chain / few iterations just so example runs quickly
#'   # do not use in practice
#'   chains = 1, iter = 500)
#'
#' # Once we've fit the model, we can use emmeans() (and functions
#' # from that package) to get whatever marginal distributions we want.
#' # For example, we can get marginal means by condition:
#' m %>%
#'   emmeans(~ condition) %>%
#'   gather_emmeans_draws() %>%
#'   median_qi()
#'
#' # or we could get pairwise differences:
#' m %>%
#'   emmeans(~ condition) %>%
#'   contrast(method = "pairwise") %>%
#'   gather_emmeans_draws() %>%
#'   median_qi()
#'
#' # see the documentation of emmeans() for more examples of types of
#' # contrasts supported by that packge.
#'
#' @importFrom magrittr %>%
#' @importFrom purrr map_dfr
#' @importFrom tibble as_tibble
#' @importFrom rlang syms
#' @export
gather_emmeans_draws = function(object, value = ".value") {
  grid = as_tibble(object@grid)

  # this matrix will have n_iterations rows and nrow(grid) columns,
  # where mat[, i] is the posterior distribution for grid[i, ]
  mat = object@post.beta %*% t(object@linfct)

  draws = map_dfr(seq_len(nrow(grid)), function(i) {
    post = as.vector(mat[, i])
    if (!is.null(offset <- object@grid[i, ".offset."])) {
      post = post + offset
    }
    cbind(
      grid[i, ],
      .chain = as.integer(NA),
      .iteration = as.integer(NA),
      .draw = seq_along(post),
      .value = post
    )
  })

  names(draws)[names(draws) == ".value"] = value

  draws[, setdiff(names(draws), c(".wgt.", ".offset."))] %>%
    as_tibble() %>%
    group_by_at(setdiff(names(.), c(".chain", ".iteration", ".draw", value)))
}
