% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_3d.R
\name{pca_3d}
\alias{pca_3d}
\title{Create 3d PCA plots}
\usage{
pca_3d(
  micro_set,
  table,
  time_var,
  subject,
  y = clr,
  modes = c("AC", "BA", "CB"),
  dist_method = "euclidean",
  type = "PCoA",
  plot_scores = FALSE,
  n_compA,
  n_compB,
  n_compC,
  cex.axis = 1,
  cex.lab = 1,
  main = NULL,
  subtitle = NULL,
  scalewt = TRUE
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{time_var}{The time point variable column name in your tidi_MIBI set}

\item{subject}{The subject variable column name in your tidi_MIBI set}

\item{y}{Value to calculate principle components or coordinates on. Default is centered log ratio (recommended)}

\item{modes}{Components of the data to focus on: time, subjects, bacteria, etc. "AC" by default}

\item{dist_method}{Dissimilartiy method to be calculated by \code{\link[vegan]{vegdist}}. Euclidean by default}

\item{type}{"PCA" for principle components or "PCoA" to calculated dissimilarity matrix using \code{\link[vegan]{vegdist}}}

\item{plot_scores}{Plot the scores instead of the principle components}

\item{n_compA}{The number of components along first axis. See details}

\item{n_compB}{The number of components along second axis. See details}

\item{n_compC}{The number of components along third axis. See details}

\item{cex.axis}{Options for \code{\link[scatterplot3d]{scatterplot3d}}}

\item{cex.lab}{Options for \code{\link[scatterplot3d]{scatterplot3d}}}

\item{main}{Plot title}

\item{subtitle}{Plot subtitle}

\item{scalewt}{Logical; center and scale OTU table, recommended}
}
\description{
Create three dimensional PCA plots from longitudinal data or multiple omics data sets.
}
\details{
Requires that you have columns for subject name and time point. Data must be complete across time points. The function will filter out inconsistent subjects

When type = "PCoA" the component matrices must be specified prior to the optimization. This is handled automatically.

If n_compA, n_compB, and n_compC aren't specified they will default to the number of complete subjects, the number of taxa, and the number of time points, respectively. This slows down performance slightly, but will not change the results.
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)

otu_tabs = list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin)

set \%>\% pca_3d(table = "Family", time_var = day, subject = study_id)
}
\references{
\code{\link[vegan]{vegdist}}
}
\author{
Charlie Carpenter, Kayla Williamson
}
