% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_bars.R
\name{bb_bars}
\alias{bb_bars}
\title{Create stacked bar charts based on beta binomial model estimates}
\usage{
bb_bars(
  modsum,
  ...,
  range,
  quant_style = c("continuous", "discrete"),
  top_taxa = 0,
  RA = 0,
  specific_taxa,
  lines = TRUE,
  xaxis,
  main,
  subtitle,
  xlab,
  ylab = "Relative Abundance (\%)",
  facet_labels,
  facet_layout = 1
)
}
\arguments{
\item{modsum}{The output from bb_mods}

\item{...}{The covariate you'd like to plot. Can be an interaction term or main effect, but must be in the models created by bb_mods}

\item{range}{The range you'd like to plot over for a quantitative variable. Will default to the first and third quartiles}

\item{quant_style}{"continuous" will plot over the entire range specified; "discrete" will plot only the endpoints of the range specified. "continuous" by default. This option is ignored without a quantitative variable}

\item{top_taxa}{Only plot X taxa with the highest relative abundance. The rest will be aggregated into an "Other" category}

\item{RA}{Only plot taxa with a relative abundance higher than X. The rest will be aggregated into an "Other" category}

\item{specific_taxa}{Character; Plot these specific taxa even if it doesn't meet the top_taxa or RA requirements}

\item{lines}{Logical; Add outlines around the different taxa colors in the stacked bar charts}

\item{xaxis}{Labels for the x-axis ticks. Most useful for categorical variables and defaults to the levels of the variable}

\item{main}{Plot title}

\item{subtitle}{Subtitle for the plot}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{facet_labels}{Labels for the facets created for interaction terms}

\item{facet_layout}{Rearrange the facets created for interaction terms}
}
\value{
Returns a ggplot that you can add geoms to if you'd like
}
\description{
bb_bars takes the output from bb_mods and creates stacked bar charts of the estimated relative abundance for each taxa. The benefit of modeling each taxa before created stacked bar charts is the ability to control for potential confounders. The function will facet wrap interaction terms. Currently, only quant_style = "discrete" can be used for an interaction between two quantitative variables
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)
otu_tabs = list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin) \%>\%
filter(day == 7) ## Only including the first week

## Creating beta binomial models on filtered tidy_micro set
\donttest{
bb_phy <- set \%>\%
otu_filter(ra_cutoff = 0.1, exclude_taxa = c("Unclassified", "Bacteria")) \%>\%
bb_mods(table = "Phylum", bpd1)

bb_phy \%>\%
bb_bars(bpd1, top_taxa = 4, xlab = "BPD Severity")
}
}
