% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tribble.R
\name{tribble}
\alias{tribble}
\title{Row-wise tibble creation}
\usage{
tribble(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>
Arguments specifying the structure of a \code{tibble}.
Variable names should be formulas, and may only appear before the data.
These arguments are processed with \code{\link[rlang:list2]{rlang::list2()}}
and support unquote via \code{\link{!!}} and unquote-splice via \code{\link{!!!}}.}
}
\value{
A \link{tibble}.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

Create \link{tibble}s using an easier to read row-by-row layout.
This is useful for small tables of data where readability is
important.  Please see \link{tibble-package} for a general introduction.
}
\examples{
tribble(
  ~colA, ~colB,
  "a",   1,
  "b",   2,
  "c",   3
)

# tribble will create a list column if the value in any cell is
# not a scalar
tribble(
  ~x,  ~y,
  "a", 1:3,
  "b", 4:6
)
}
\seealso{
See \link{quasiquotation} for more details on tidy dots semantics,
i.e. exactly how  the \code{...} argument is processed.
}
