% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{sim_TIRT_data}
\alias{sim_TIRT_data}
\title{Simulate Thurstonian IRT data}
\usage{
sim_TIRT_data(npersons, ntraits, lambda, gamma, psi = NULL, Phi = NULL,
  eta = NULL, family = "bernoulli", nblocks_per_trait = 5,
  nitems_per_block = 3, comb_blocks = c("random", "fixed"))
}
\arguments{
\item{npersons}{Number of persons.}

\item{ntraits}{Number of traits.}

\item{lambda}{Item factor loadings.}

\item{gamma}{Baseline attractiveness parameters of the
first item versus the second item in the pairwise comparisons.
Can be thought of as intercept parameters.}

\item{psi}{Optional item uniquenesses. If not provided,
they will be computed as \code{psi = 1 - lambda^2} in which
case lambda are taken to be the standardized factor loadings.}

\item{Phi}{Optional trait correlation matrix from which to sample
person factor scores. Only used if \code{eta} is not provided.}

\item{eta}{Optional person factor scores. If provided, argument
\code{Phi} will be ignored.}

\item{family}{Name of assumed the response distribution. Either
\code{"bernoulli"}, \code{"cumulative"}, or \code{"gaussian"}.}

\item{nblocks_per_trait}{Number of blocks per trait.}

\item{nitems_per_block}{Number of items per block.}

\item{comb_blocks}{Indicates how to combine traits to blocks.
\code{"fixed"} implies a simple non-random design that may combine
certain traits which each other disproportionally often. We thus
recommend to use a \code{"random"} block design (the default) that
combines all traits with all other traits equally often on average.}
}
\value{
A \code{data.frame} of the same structure
as returned by \code{\link{make_TIRT_data}}. Parameter values
from which the data were simulated are stored as attributes
of the returned object.
}
\description{
Simulate Thurstonian IRT data
}
\examples{
# simulate some data
sdata <- sim_TIRT_data(
  npersons = 100,
  ntraits = 3,
  nblocks_per_trait = 4,
  gamma = 0,
  lambda = c(runif(6, 0.5, 1), runif(6, -1, -0.5)),
  Phi = diag(3)
)

# take a look at the data
head(sdata)
str(attributes(sdata))

\donttest{
# fit a Thurstonian IRT model using lavaan
fit <- fit_TIRT_lavaan(sdata)
print(fit)
}

}
