% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pstoveg_sample.R
\name{pstoveg_sample}
\alias{pstoveg_sample}
\title{Converts sample_data slot of a phyloseq object to vegan-compatible matrix}
\usage{
pstoveg_sample(PS)
}
\arguments{
\item{PS}{(required) a phyloseq object}
}
\value{
A matrix containing a phyloseq object's otu_table slot.
}
\description{
physeq2veg_otu is a helper function intended to convert the species/taxa
count slot of a phyloseq object to a vegan-friendly matrix.
}
\examples{
\dontrun{
library(phyloseq)
data("GlobalPatterns")
# inspect otu_table()
dim(otu_table(GlobalPatterns))
str(otu_table(GlobalPatterns))
taxa_are_rows(GlobalPatterns)
gp.otu <- physeq2veg_otu(GlobalPatterns)
dim(gp.otu)
str(gp.otu)
}

}
\seealso{
\code{\link[phyloseq]{phyloseq-class}}
  \code{\link[phyloseq]{otu_table-class}} \code{\link[phyloseq]{otu_table}}
}
