hclust_every_cluster <- function(km, df, parallel = TRUE) {
    if (!rlang::has_name(km, "data")) {
        km$data <- df %>%
            left_join(km$cluster, by = colnames(df)[1]) %>%
            select(clust, everything()) %>%
            as_tibble()
    }

    all_hc <- km$data %>%
        plyr::dlply(plyr::.(clust), function(x) {
            ids <- x$id
            hc <- as.matrix(x[, -1:-2]) %>%
                t() %>%
                tgs_cor(pairwise.complete.obs = TRUE, spearman = TRUE) %>%
                tgs_dist() %>%
                hclust(method = "ward.D2")
            return(tibble(clust = x$clust[1], id = ids, intra_clust_order = hc$order))
        }, .parallel = parallel) %>%
        purrr::map_df(~.x)

    res <- km$data %>%
        select(id, clust) %>%
        mutate(idx = 1:n()) %>%
        left_join(all_hc, by = c("id", "clust")) %>%
        arrange(clust, intra_clust_order) %>%
        mutate(order = 1:n()) %>%
        arrange(idx) %>%
        select(id, clust, order, intra_clust_order)
    return(res)
}
