% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_vector_deterministic}
\alias{tfd_vector_deterministic}
\title{Vector Deterministic Distribution}
\usage{
tfd_vector_deterministic(loc, atol = NULL, rtol = NULL,
  validate_args = FALSE, allow_nan_stats = TRUE,
  name = "VectorDeterministic")
}
\arguments{
\item{loc}{Numeric Tensor of shape [B1, ..., Bb, k], with b >= 0, k >= 0 The
point (or batch of points) on which this distribution is supported.}

\item{atol}{Non-negative Tensor of same dtype as loc and broadcastable shape.
The absolute tolerance for comparing closeness to loc. Default is 0.}

\item{rtol}{Non-negative Tensor of same dtype as loc and broadcastable shape.
The relative tolerance for comparing closeness to loc. Default is 0.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The VectorDeterministic distribution is parameterized by a batch point loc in R^k.
The distribution is supported at this point only, and corresponds to a random
variable that is constant, equal to loc.
}
\details{
See \href{https://en.wikipedia.org/wiki/Degenerate_distribution}{Degenerate rv}.
}
