% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_joint_distribution_named_auto_batched}
\alias{tfd_joint_distribution_named_auto_batched}
\title{Joint distribution parameterized by named distribution-making functions.}
\usage{
tfd_joint_distribution_named_auto_batched(
  model,
  batch_ndims = 0,
  use_vectorized_map = TRUE,
  validate_args = FALSE,
  name = NULL
)
}
\arguments{
\item{model}{A generator that yields a sequence of \code{tfd$Distribution}-like
instances.}

\item{batch_ndims}{\code{integer} \code{Tensor} number of batch dimensions. The \code{batch_shape}s
of all component distributions must be such that the prefixes of
length \code{batch_ndims} broadcast to a consistent joint batch shape.
Default value: \code{0}.}

\item{use_vectorized_map}{\code{logical}. Whether to use \code{tf$vectorized_map}
to automatically vectorize evaluation of the model. This allows the
model specification to focus on drawing a single sample, which is often
simpler, but some ops may not be supported. Default value: \code{TRUE}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
This class provides automatic vectorization and alternative semantics for
\code{tfd_joint_distribution_named()}, which in many cases allows for
simplifications in the model specification.
}
\details{
Automatic vectorization

Auto-vectorized variants of JointDistribution allow the user to avoid
explicitly annotating a model's vectorization semantics.
When using manually-vectorized joint distributions, each operation in the
model must account for the possibility of batch dimensions in Distributions
and their samples. By contrast, auto-vectorized models need only describe
a \emph{single} sample from the joint distribution; any batch evaluation is
automated using \code{tf$vectorized_map} as required. In many cases this
allows for significant simplications. For example, the following
manually-vectorized \code{tfd_joint_distribution_named()} model:

\if{html}{\out{<div class="sourceCode">}}\preformatted{model <- tfd_joint_distribution_sequential(
    list(
      x = tfd_normal(loc = 0, scale = tf$ones(3L)),
      y = tfd_normal(loc = 0, scale = 1),
      z = function(y, x) \{
        tfd_normal(loc = x[reticulate::py_ellipsis(), 1:2] + y[reticulate::py_ellipsis(), tf$newaxis], scale = 1)
      \}
    )
)
}\if{html}{\out{</div>}}

can be written in auto-vectorized form as

\if{html}{\out{<div class="sourceCode">}}\preformatted{model <- tfd_joint_distribution_sequential_auto_batched(
  list(
    x = tfd_normal(loc = 0, scale = tf$ones(3L)),
    y = tfd_normal(loc = 0, scale = 1),
    z = function(y, x) \{tfd_normal(loc = x[1:2] + y, scale = 1)\}
  )
)
}\if{html}{\out{</div>}}

in which we were able to avoid explicitly accounting for batch dimensions
when indexing and slicing computed quantities in the third line.
Note: auto-vectorization is still experimental and some TensorFlow ops may
be unsupported. It can be disabled by setting \code{use_vectorized_map=FALSE}.

Alternative batch semantics
This class also provides alternative semantics for specifying a batch of
independent (non-identical) joint distributions.
Instead of simply summing the \code{log_prob}s of component distributions
(which may have different shapes), it first reduces the component \code{log_prob}s
to ensure that \code{jd$log_prob(jd$sample())} always returns a scalar, unless
\code{batch_ndims} is explicitly set to a nonzero value (in which case the result
will have the corresponding tensor rank).

The essential changes are:
\itemize{
\item An \code{event} of \code{JointDistributionNamedAutoBatched} is the list of
tensors produced by \verb{$sample()}; thus, the \code{event_shape} is the
list containing the shapes of sampled tensors. These combine both
the event and batch dimensions of the component distributions. By contrast,
the event shape of a base \code{JointDistribution}s does not include batch
dimensions of component distributions.
\item The \code{batch_shape} is a global property of the entire model, rather
than a per-component property as in base \code{JointDistribution}s.
The global batch shape must be a prefix of the batch shapes of
each component; the length of this prefix is specified by an optional
argument \code{batch_ndims}. If \code{batch_ndims} is not specified, the model has
batch shape \verb{()}.#'
}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
