% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-methods.R
\name{tfd_covariance}
\alias{tfd_covariance}
\title{Covariance.}
\usage{
tfd_covariance(distribution, ...)
}
\arguments{
\item{distribution}{The distribution being used.}

\item{...}{Additional parameters passed to Python.}
}
\value{
Floating-point Tensor with shape \verb{[B1, ..., Bn, k, k]} where the first n dimensions
are batch coordinates and \code{k = reduce_prod(self.event_shape)}.
}
\description{
Covariance is (possibly) defined only for non-scalar-event distributions.
For example, for a length-k, vector-valued distribution, it is calculated as,
\code{Cov[i, j] = Covariance(X_i, X_j) = E[(X_i - E[X_i]) (X_j - E[X_j])]}
where Cov is a (batch of) k x k matrix, 0 <= (i, j) < k, and E denotes expectation.
}
\details{
Alternatively, for non-vector, multivariate distributions (e.g., matrix-valued, Wishart),
Covariance shall return a (batch of) matrices under some vectorization of the events, i.e.,
\verb{Cov[i, j] = Covariance(Vec(X)_i, Vec(X)_j) = [as above]}
where Cov is a (batch of) k x k matrices, 0 <= (i, j) < k = reduce_prod(event_shape),
and Vec is some function mapping indices of this distribution's event dimensions to indices of a
length-k vector.
}
\examples{
\donttest{
d <- tfd_normal(loc = c(1, 2), scale = c(1, 0.5))
d \%>\% tfd_variance()
}
}
\seealso{
Other distribution_methods: 
\code{\link{tfd_cdf}()},
\code{\link{tfd_cross_entropy}()},
\code{\link{tfd_entropy}()},
\code{\link{tfd_kl_divergence}()},
\code{\link{tfd_log_cdf}()},
\code{\link{tfd_log_prob}()},
\code{\link{tfd_log_survival_function}()},
\code{\link{tfd_mean}()},
\code{\link{tfd_mode}()},
\code{\link{tfd_prob}()},
\code{\link{tfd_quantile}()},
\code{\link{tfd_sample}()},
\code{\link{tfd_stddev}()},
\code{\link{tfd_survival_function}()},
\code{\link{tfd_variance}()}
}
\concept{distribution_methods}
