% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi-functions.R
\name{vi_triangular}
\alias{vi_triangular}
\title{The Triangular Csiszar-function in log-space}
\usage{
vi_triangular(logu, name = NULL)
}
\arguments{
\item{logu}{\code{float}-like \code{Tensor} representing \code{log(u)} from above.}

\item{name}{name prefixed to Ops created by this function.}
}
\value{
triangular_of_u: \code{float}-like \code{Tensor} of the Csiszar-function
evaluated at \code{u = exp(logu)}.
}
\description{
The Triangular Csiszar-function is:
}
\details{
\preformatted{f(u) = (u - 1)**2 / (1 + u)
}

Warning: this function makes non-log-space calculations and may
therefore be numerically unstable for \verb{|logu| >> 0}.
}
\seealso{
Other vi-functions#': 
\code{\link{vi_t_power}()},
\code{\link{vi_total_variation}()}
}
\concept{vi-functions#'}
