% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi-functions.R
\name{vi_amari_alpha}
\alias{vi_amari_alpha}
\title{The Amari-alpha Csiszar-function in log-space}
\usage{
vi_amari_alpha(logu, alpha = 1, self_normalized = FALSE, name = NULL)
}
\arguments{
\item{logu}{\code{float}-like \code{Tensor} representing \code{log(u)} from above.}

\item{alpha}{\code{float}-like scalar.}

\item{self_normalized}{\code{logical} indicating whether \verb{f'(u=1)=0}. When
\verb{f'(u=1)=0} the implied Csiszar f-Divergence remains non-negative even
when \verb{p, q} are unnormalized measures.}

\item{name}{name prefixed to Ops created by this function.}
}
\value{
amari_alpha_of_u \code{float}-like \code{Tensor} of the Csiszar-function evaluated
at \code{u = exp(logu)}.
}
\description{
A Csiszar-function is a member of \verb{F = \{ f:R_+ to R : f convex \}}.
}
\details{
When \code{self_normalized = TRUE}, the Amari-alpha Csiszar-function is:\preformatted{f(u) = \{ -log(u) + (u - 1)\},     alpha = 0
       \{ u log(u) - (u - 1)\},    alpha = 1
       \{ ((u^alpha - 1) - alpha (u - 1) / (alpha (alpha - 1))\},    otherwise
}

When \code{self_normalized = FALSE} the \code{(u - 1)} terms are omitted.

Warning: when \code{alpha != 0} and/or \code{self_normalized = True} this function makes
non-log-space calculations and may therefore be numerically unstable for
\verb{|logu| >> 0}.
}
\section{References}{

\itemize{
\item A. Cichocki and S. Amari. "Families of Alpha-Beta-and GammaDivergences: Flexible and Robust Measures of Similarities." Entropy, vol. 12, no. 6, pp. 1532-1568, 2010.
}
}

\seealso{
Other vi-functions: 
\code{\link{vi_arithmetic_geometric}()},
\code{\link{vi_chi_square}()},
\code{\link{vi_csiszar_vimco}()},
\code{\link{vi_dual_csiszar_function}()},
\code{\link{vi_fit_surrogate_posterior}()},
\code{\link{vi_jeffreys}()},
\code{\link{vi_jensen_shannon}()},
\code{\link{vi_kl_forward}()},
\code{\link{vi_kl_reverse}()},
\code{\link{vi_log1p_abs}()},
\code{\link{vi_modified_gan}()},
\code{\link{vi_monte_carlo_variational_loss}()},
\code{\link{vi_pearson}()},
\code{\link{vi_squared_hellinger}()},
\code{\link{vi_symmetrized_csiszar_function}()}
}
\concept{vi-functions}
