% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{summary_text}
\alias{summary_text}
\alias{summary_text.character}
\title{Creates a text summary}
\usage{
summary_text(txt, ..., metadata = NULL, tag = NA)

\method{summary_text}{character}(txt, ..., metadata = NULL, tag = NA)
}
\arguments{
\item{txt}{An object that can be converted to a text.}

\item{...}{Currently unused.}

\item{metadata}{A \code{metadata} object, as created with \code{\link[=summary_metadata]{summary_metadata()}}. In
most cases you don't need to change the default.}

\item{tag}{A tag that within the TensorBoard UI. See \code{\link[=log_event]{log_event()}} for other
ways of specifying the tag attribute.}
}
\value{
A summary that can be logged with \code{\link[=log_event]{log_event()}}.
}
\description{
Creates a text summary
}
\section{Methods (by class)}{
\itemize{
\item \code{summary_text(character)}: Creates a summary from a scalar character vector.

}}
\examples{
temp <- tempfile()
with_logdir(temp, {
  log_event(
    x = "hello world",
    y = summary_text("hello world")
  )
})
}
\seealso{
Other summary: 
\code{\link{summary_audio}()},
\code{\link{summary_histogram}()},
\code{\link{summary_image}()},
\code{\link{summary_scalar}()}
}
\concept{summary}
