% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tf_arg}
\alias{tf_arg}
\alias{tf_evaluations}
\alias{tf_count}
\alias{tf_domain}
\alias{tf_domain<-}
\alias{tf_evaluator}
\alias{tf_evaluator<-}
\alias{tf_basis}
\alias{tf_arg<-}
\alias{tf_arg<-.tfd_irreg}
\alias{tf_arg<-.tfd_reg}
\alias{tf_arg<-.tfb}
\alias{coef.tfb}
\alias{rev.tf}
\alias{is.na.tf}
\alias{is.na.tfd_irreg}
\alias{is_tf}
\alias{is_tfd}
\alias{is_reg}
\alias{is_tfd_reg}
\alias{is_irreg}
\alias{is_tfd_irreg}
\alias{is_tfb}
\alias{is_tfb_spline}
\alias{is_tfb_fpc}
\title{Utility functions for \code{tf}-objects}
\usage{
tf_arg(f)

tf_evaluations(f)

tf_count(f)

tf_domain(f)

tf_domain(x) <- value

tf_evaluator(f)

tf_evaluator(x) <- value

tf_basis(f, as_tfd = FALSE)

tf_arg(x) <- value

\method{tf_arg}{tfd_irreg}(x) <- value

\method{tf_arg}{tfd_reg}(x) <- value

\method{tf_arg}{tfb}(x) <- value

\method{coef}{tfb}(object, ...)

\method{rev}{tf}(x)

\method{is.na}{tf}(x)

\method{is.na}{tfd_irreg}(x)

is_tf(x)

is_tfd(x)

is_reg(x)

is_tfd_reg(x)

is_irreg(x)

is_tfd_irreg(x)

is_tfb(x)

is_tfb_spline(x)

is_tfb_fpc(x)
}
\arguments{
\item{f}{an \code{tf} object}

\item{x}{an \code{tf} object}

\item{value}{\strong{for \verb{tf_evaluator<-}:} (bare or quoted) name of a function
that can be used to interpolate an \code{tfd}. Needs to accept vector arguments
\code{x}, \code{arg}, \code{evaluations} and return evaluations of the function defined by
\code{arg}, \code{evaluations} at \code{x}. \cr
\strong{for \verb{tf_arg<-}:} (list of) new \code{arg}-values. \cr
\strong{for \verb{tf_domain<-}:} sorted numeric vector with the 2 new endpoints of
the domain. \cr}

\item{as_tfd}{should the basis be returned as a \code{tfd}-vector evaluated on
\code{tf_arg(f)}? Defaults to \code{FALSE}, which returns the matrix of basis functions
(columns) evaluated on \code{tf_arg(f)} (rows).}

\item{object}{as usual}

\item{...}{dots}
}
\value{
either the respective attribute or, for setters (assignment functions),
the input object with modified properties.
}
\description{
A bunch of methods & utilities that do what they say: get or set the
respective attributes of a \code{tf}-object.
}
\seealso{
Other tidyfun utility functions: 
\code{\link{in_range}()},
\code{\link{tf_zoom}()}
}
\concept{tidyfun utility functions}
