% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{tf_evaluate}
\alias{tf_evaluate}
\alias{tf_evaluate.default}
\alias{tf_evaluate.tfd}
\alias{tf_evaluate.tfb}
\title{Evaluate \code{tf}-vectors for given argument values}
\usage{
tf_evaluate(object, arg, ...)

\method{tf_evaluate}{default}(object, arg, ...)

\method{tf_evaluate}{tfd}(object, arg, evaluator = tf_evaluator(object), ...)

\method{tf_evaluate}{tfb}(object, arg, ...)
}
\arguments{
\item{object}{a \code{tf}, or a \code{data.frame}-like object with \code{tf} columns.}

\item{arg}{optional evaluation grid (vector or list of vectors).
Defaults to \code{tf_arg(object)}, implicitly.}

\item{...}{not used}

\item{evaluator}{optional. The function to use for inter/extrapolating the
\code{tfd}. Defaults to \code{tf_evaluator(object)}.
See e.g. \code{\link[=tf_approx_linear]{tf_approx_linear()}} for details.}
}
\value{
A list of numeric vectors containing the function
evaluations on \code{arg}.
}
\description{
Also used internally by the \code{[}-operator for \code{tf} data (see \code{?tfbrackets}) to
evaluate \code{object}, see examples.
}
\examples{
f <- tf_rgp(3, arg = seq(0, 1, length.out = 11))
tf_evaluate(f) |> str()
tf_evaluate(f, arg = 0.5) |> str()
# equivalent, as matrix:
f[, 0.5]
new_grid <- seq(0, 1, length.out = 6)
tf_evaluate(f, arg = new_grid) |> str()
# equivalent, as matrix:
f[, new_grid]
}
\seealso{
Other tidyfun inter/extrapolation functions: 
\code{\link{tf_approx_linear}()},
\code{\link{tf_interpolate}()}
}
\concept{tidyfun inter/extrapolation functions}
