% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_sentence_token.R
\name{split_sentence_token}
\alias{split_sentence_token}
\alias{split_sentence_token.default}
\alias{split_sentence_token.data.frame}
\title{Split Sentences & Tokens}
\usage{
split_sentence_token(x, ...)

\method{split_sentence_token}{default}(x, lower = TRUE, ...)

\method{split_sentence_token}{data.frame}(x, text.var = TRUE, lower = TRUE,
  ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with sentences.}

\item{lower}{logical.  If \code{TRUE} the words are converted to lower case.}

\item{text.var}{The name of the text variable.  If \code{TRUE}
\code{split_sentence_token} tries to detect the column with sentences.}

\item{\ldots}{Ignored.}
}
\value{
Returns a list of vectors of sentences or a expanded
\code{\link[base]{data.frame}} with sentences split apart.
}
\description{
Split sentences and tokens.
}
\examples{
(x <- c(paste0(
    "Mr. Brown comes! He says hello. i give him coffee.  i will ",
    "go at 5 p. m. eastern time.  Or somewhere in between!go there"
),
paste0(
    "Marvin K. Mooney Will You Please Go Now!", "The time has come.",
    "The time has come. The time is now. Just go. Go. GO!",
    "I don't care how."
)))
split_sentence_token(x)

data(DATA)
split_sentence_token(DATA)

\dontrun{
## Kevin S. Dias' sentence boundary disambiguation test set
data(golden_rules)
library(magrittr)

golden_rules \%$\%
    split_sentence_token(Text)
}
}
