% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_index.R
\name{split_index}
\alias{split_index}
\alias{split_index.list}
\alias{split_index.data.frame}
\alias{split_index.matrix}
\alias{split_index.numeric}
\alias{split_index.factor}
\alias{split_index.character}
\alias{split_index.default}
\title{Split Data Forms at Specified Indices}
\usage{
split_index(x, indices = if (is.atomic(x)) {     NULL } else {    
  change_index(x) }, names = NULL, ...)

\method{split_index}{list}(x, indices, names = NULL, ...)

\method{split_index}{data.frame}(x, indices, names = NULL, ...)

\method{split_index}{matrix}(x, indices, names = NULL, ...)

\method{split_index}{numeric}(x, indices = change_index(x), names = NULL,
  ...)

\method{split_index}{factor}(x, indices = change_index(x), names = NULL,
  ...)

\method{split_index}{character}(x, indices = change_index(x), names = NULL,
  ...)

\method{split_index}{default}(x, indices = change_index(x), names = NULL,
  ...)
}
\arguments{
\item{x}{A data form (\code{list}, \code{vector}, \code{data.frame},
\code{matrix}).}

\item{indices}{A vector of integer indices to split at.  If \code{indices}
contains the index 1, it will be silently dropped.  The default value when
\code{x} evaluates to \code{TRUE} for \code{\link[base]{is.atomic}} is to use
\code{\link[textshape]{change_index}(x)}.}

\item{names}{Optional vector of names to give to the list elements.}

\item{\ldots}{Ignored.}
}
\value{
Returns of list of data forms broken at the \code{indices}.
}
\description{
Split data forms at specified integer indices.
}
\note{
Two dimensional object will retain dimension (i.e., \code{drop = FALSE}
is used).
}
\examples{
## character
split_index(LETTERS, c(4, 10, 16))
split_index(LETTERS, c(4, 10, 16), c("dog", "cat", "chicken", "rabbit"))

## numeric
split_index(1:100, c(33, 66))

## factor
(p_chng <- change_index(CO2[["Plant"]]))
split_index(CO2[["Plant"]], p_chng)
#`change_index` was unnecessary as it is the default of atomic vectors
split_index(CO2[["Plant"]])

## list
split_index(as.list(LETTERS), c(4, 10, 16))

## data.frame
(vs_change <- change_index(mtcars[["vs"]]))
split_index(mtcars, vs_change)

## matrix
(mat <- matrix(1:50, nrow=10))
split_index(mat, c(3, 6, 10))
}
\seealso{
\code{\link[textshape]{change_index}}
}
