% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_speaker.R
\name{split_speaker}
\alias{split_speaker}
\title{Break and Stretch if Multiple Persons per Cell}
\usage{
split_speaker(dataframe, speaker.var = 1, sep = c("and", "&", ","),
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{dataframe}{A dataframe that contains the person variable.}

\item{speaker.var}{The person variable to be stretched.}

\item{sep}{The separator(s) to search for and break on.  Default is:
c("and", "&", ",")}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns an expanded dataframe with person variable stretched and
accompanying rows repeated.
}
\description{
Look for cells with multiple people and create separate rows for each person.
}
\examples{
\dontrun{
DATA$person <- as.character(DATA$person)
DATA$person[c(1, 4, 6)] <- c("greg, sally, & sam",
    "greg, sally", "sam and sally")

split_speaker(DATA)

DATA$person[c(1, 4, 6)] <- c("greg_sally_sam",
    "greg.sally", "sam; sally")

split_speaker(DATA, sep = c(".", "_", ";"))

DATA <- textshape::DATA  #reset DATA
}
}

