% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_run.R
\name{split_run}
\alias{split_run}
\alias{split_run.data.frame}
\alias{split_run.default}
\title{Split Runs}
\usage{
split_run(x, ...)

\method{split_run}{default}(x, ...)

\method{split_run}{data.frame}(x, text.var = TRUE,
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with runs.}

\item{text.var}{The name of the text variable with runs. If \code{TRUE}
\code{split_word} tries to detect the text column with runs.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a list of vectors of runs or an expanded
\code{\link[data.table]{data.table}} with runs split apart.
}
\description{
Split runs of consecutive characters.
}
\examples{
x1 <- c(
     "122333444455555666666",
     NA,
     "abbcccddddeeeeeffffff",
     "sddfg",
     "11112222333"
)

x <- c(rep(x1, 2), ">>???,,,,....::::;[[")

split_run(x)


DATA[["run.col"]] <- x
split_run(DATA, "run.col")
}

