% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tts_amazon_auth.R, R/tts_auth.R,
%   R/tts_google_auth.R, R/tts_microsoft_auth.R
\name{tts_amazon_auth}
\alias{tts_amazon_auth}
\alias{tts_auth}
\alias{tts_google_authenticated}
\alias{tts_amazon_authenticated}
\alias{tts_microsoft_authenticated}
\alias{tts_google_auth}
\alias{tts_microsoft_auth}
\title{Authorize Text-to-Speech Engine}
\usage{
tts_amazon_auth(key_or_json_file = NULL, ...)

tts_auth(
  service = c("amazon", "google", "microsoft"),
  key_or_json_file = NULL,
  ...
)

tts_google_authenticated()

tts_amazon_authenticated()

tts_microsoft_authenticated(...)

tts_google_auth(key_or_json_file = NULL, ...)

tts_microsoft_auth(key_or_json_file = NULL, ...)
}
\arguments{
\item{key_or_json_file}{Either an API key (for Microsoft)
or JSON file (for Google)}

\item{...}{Additional arguments to pass to
\code{\link{use_credentials}} or \code{\link{ms_get_tts_token}}}

\item{service}{type of synthesis engine}
}
\value{
A logical indicator of authorization
}
\description{
Authorize Text-to-Speech Engine
}
\examples{
tts_auth("google")
tts_auth("microsoft")

tts_google_authenticated()
tts_microsoft_authenticated()

tts_google_auth()
tts_microsoft_auth()
if (requireNamespace("aws.polly", quietly = TRUE)) {
tts_auth("amazon")
tts_amazon_authenticated()
tts_amazon_auth()
}
}
