% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_3_textPlotProjection.R
\name{textProjection}
\alias{textProjection}
\title{Compute Supervised Dimension Projection and related variables for plotting words.}
\usage{
textProjection(
  words,
  word_embeddings,
  word_types_embeddings,
  x,
  y = NULL,
  pca = NULL,
  aggregation = "mean",
  split = "quartile",
  word_weight_power = 1,
  min_freq_words_test = 0,
  mean_centering = FALSE,
  mean_centering2 = FALSE,
  Npermutations = 10000,
  n_per_split = 50000,
  seed = 1003
)
}
\arguments{
\item{words}{(character) Word or text variable to be plotted.}

\item{word_embeddings}{Word embeddings from textEmbed for the words to be plotted
(i.e., the aggregated word embeddings for the "words" parameter).}

\item{word_types_embeddings}{Word embeddings from textEmbed for individual words
(i.e., decontextualized embeddings).}

\item{x}{Numeric variable that the words should be plotted according to on the x-axes.}

\item{y}{Numeric variable that the words should be plotted according to on the y-axes
(default = NULL, i.e., a 1-dimensional plot is created).}

\item{pca}{Number of PCA dimensions applied to the word embeddings in the beginning of the
function (default = NULL).
 A number below 1 takes out \% of variance; An integer specify number of components to extract.
(default is NULL as this setting has not yet been evaluated).}

\item{aggregation}{(character) Method to aggregate the word embeddings
(default = "mean"; see also "min", "max", and "[CLS]").}

\item{split}{(character) Method to split the axes
(default = "quartile" involving selecting lower and upper quartile; see also "mean"). However, if the variable is
only containing two different values (i.e., being dichotomous) mean split is used.}

\item{word_weight_power}{Compute the power of the frequency of the words and multiply
the word embeddings with this in the computation of aggregated word embeddings for
group low (1) and group high (2). This increases the weight of more frequent words.}

\item{min_freq_words_test}{(numeric) Option to select words that have occurred a specified number of
times (default = 0); when creating the Supervised Dimension Projection line
(i.e., single words receive Supervised Dimension Projection and p-value).}

\item{mean_centering}{(boolean) Separately mean centering the Group 1 split aggregation embedding,
and the Group 2 split aggregation embedding}

\item{mean_centering2}{(boolean) Separately mean centering the G1 and G2 split aggregation embeddings}

\item{Npermutations}{(numeric) Number of permutations in the creation of the null distribution (default = 10000).}

\item{n_per_split}{(numeric) Setting to split Npermutations to avoid reaching computer memory limits;
set it lower than Npermutations <- and the higher it is set the faster the computation completes,
 but too high may lead to abortion (default = 50000).}

\item{seed}{(numeric) Set different seed (default = 1003).}
}
\value{
A dataframe with variables (e.g., including Supervised Dimension Projection, frequencies, p-values)
for the individual words that is used for the plotting in the textProjectionPlot function.
}
\description{
Compute Supervised Dimension Projection and related variables for plotting words.
}
\examples{
# Pre-processing data for plotting.
\dontrun{
df_for_plotting <- textProjection(
  words = Language_based_assessment_data_8$harmonywords,
  word_embeddings = word_embeddings_4$texts$harmonywords,
  word_types_embeddings = word_embeddings_4$word_types,
  x = Language_based_assessment_data_8$hilstotal,
  split = "mean",
  Npermutations = 10,
  n_per_split = 1
)
# Run df_for_plotting to examine result.
df_for_plotting
}
}
\seealso{
See \code{\link{textProjectionPlot}}.
}
