% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textDistance}
\alias{textDistance}
\title{Compute the semantic distance between two text variables.}
\usage{
textDistance(x, y, method = "euclidean", center = FALSE, scale = FALSE)
}
\arguments{
\item{x}{Word embeddings (from textEmbed).}

\item{y}{Word embeddings (from textEmbed).}

\item{method}{Character string describing type of measure to be computed; default is "euclidean" (see also
measures from stats:dist() including "maximum", "manhattan", "canberra", "binary" and "minkowski".
It is also possible to use "cosine", which computes the cosine distance (i.e., 1 - cosine(x, y)).}

\item{center}{(boolean; from base::scale) If center is TRUE then centering is done by subtracting the column means
(omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.}

\item{scale}{(boolean; from base::scale) If scale is TRUE then scaling is done by dividing the
(centered) columns of x by their standard deviations if center is TRUE, and the root mean square otherwise.}
}
\value{
A vector comprising semantic distance scores.
}
\description{
Compute the semantic distance between two text variables.
}
\examples{
library(dplyr)
distance_scores <- textDistance(
  x = word_embeddings_4$texts$harmonytext,
  y = word_embeddings_4$texts$satisfactiontext
)
comment(distance_scores)
}
\seealso{
see  \code{\link{textSimilarity}}, \code{\link{textSimilarityNorm}} and \code{\link{textSimilarityTest}}
}
