% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,nlme-method}
\alias{extract,nlme-method}
\alias{extract.nlme}
\title{\code{\link{extract}} method for \code{nlme} objects}
\usage{
\S4method{extract}{nlme}(
  model,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.nobs = TRUE,
  include.groups = TRUE,
  include.variance = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.groups}{Report the number of groups?}

\item{include.variance}{Report group variances?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{nlme} objects created by the
\code{\link[nlme]{nlme}} function in the \pkg{nlme} package.
}
