% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,glmerMod-method}
\alias{extract,glmerMod-method}
\alias{extract.glmerMod}
\title{\code{\link{extract}} method for \code{glmerMod} objects}
\usage{
\S4method{extract}{glmerMod}(
  model,
  method = c("naive", "profile", "boot", "Wald"),
  level = 0.95,
  nsim = 1000,
  include.aic = TRUE,
  include.bic = TRUE,
  include.dic = FALSE,
  include.deviance = FALSE,
  include.loglik = TRUE,
  include.nobs = TRUE,
  include.groups = TRUE,
  include.variance = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{method}{The method used to compute confidence intervals or p-values.
The default value \code{"naive"} computes naive p-values while the other
methods compute confidence intervals using the \code{confint} function. See
\code{\link[lme4]{confint.merMod}}.}

\item{level}{Significance or confidence level (\code{1 - alpha}) for
computing confidence intervals.}

\item{nsim}{The MCMC sample size or number of bootstrapping replications on
the basis of which confidence intervals are computed (only if the
\code{method} argument does not specify \code{"naive"}, which is the
default behavior). Note: large values may take considerable computing time.}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.dic}{Report the deviance information criterion (DIC)?}

\item{include.deviance}{Report the deviance?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.groups}{Report the number of groups?}

\item{include.variance}{Report group variances?}

\item{...}{Arguments to be passed to the \code{\link[lme4]{fixef}} function
in the \pkg{lme4} package.}
}
\description{
\code{\link{extract}} method for \code{glmerMod} objects created by the
\code{\link[lme4]{glmer}} function in the \pkg{lme4} package.
}
