% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,model.selection-method}
\alias{extract,model.selection-method}
\alias{extract.model.selection}
\title{\code{\link{extract}} method for \code{model.selection} objects}
\usage{
\S4method{extract}{model.selection}(
  model,
  include.loglik = TRUE,
  include.aicc = TRUE,
  include.delta = TRUE,
  include.weight = TRUE,
  include.nobs = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.aicc}{Report AICC in the GOF block?}

\item{include.delta}{Report the delta statistic?}

\item{include.weight}{Report Akaike weights?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines. Currently
not in use.}
}
\description{
\code{\link{extract}} method for \code{model.selection} objects created by
the \code{\link[MuMIn]{model.sel}} and \code{\link[MuMIn]{dredge}} functions
in the \pkg{MuMIn} package.
}
