% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-tools.R
\name{copy_other_files}
\alias{copy_other_files}
\title{Copy Supporting Documents like images,bib file,etc.}
\usage{
copy_other_files(from_path)
}
\arguments{
\item{from_path}{String indicating base path for the working directory}
}
\value{
copies dependency files into the output folder.
}
\description{
Copies supporting documents like images,pdf,bib files into the output
folder for building the HTML version of the R-Markdown file.
}
\examples{
article_dir <- system.file("examples/article", package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
rmarkdown::pandoc_version()
texor::include_style_file(your_article_path)
rebib::aggregate_bibliography(your_article_path)
texor::copy_other_files(your_article_path)
list.files(paste0(your_article_path,"/web/"))
unlink(your_article_folder,recursive = TRUE)
}
