% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.evm.R
\name{AIC.evmOpt}
\alias{AIC.evmOpt}
\alias{AIC.evmSim}
\title{Information Criteria}
\usage{
\method{AIC}{evmOpt}(object, penalized = FALSE, nsamp = 1000, DIC, WAIC, ..., k = 2)
}
\arguments{
\item{object}{fit model object}

\item{penalized}{whether to use the penalized log-likelihood}

\item{nsamp}{Number of approximate Gaussian sample to use in computing DIC.
Defaults to \code{nsamp=1e3}. Only used when the object has class 'evmOpt'.}

\item{DIC}{Logical. Whether to compute DIC. Defaults to \code{DIC = TRUE}.
Only applicable to objects of class 'evmSim'.}

\item{WAIC}{Logical. Whether to compute WAIC. Defaults to \code{WAIC = TRUE}.
Only applicable to objects of class 'evmSim'.}

\item{...}{other arguments currently ignored}

\item{k}{numeric, the penalty per parameter to be used; the
default \code{k = 2} is the classical AIC.}
}
\value{
The AIC and DIC
}
\description{
Compute AIC and (approximate) DIC for \code{evmOpt} objects
}
\details{
If the object has class 'evmOpt', \code{nsamp} random draws are
  made from the Gaussian distribution with mean and covariance inferred from
  the model object. The result will be an approximate DIC. Note that AIC should
  not be trusted if priors are not flat. For example, if you use a regularizing
  prior on xi, say xi ~ N(0, 0.25), AIC can be misleading and DIC should be
  preferred. If the object has class 'evmSim', the actual posterior draws are
  used in the computation. Also note that sometimes the optimizer returns
  an approximatae covariance that is not postive-semidefinite, in which case
  the DIC will be reported as NA.
}
\seealso{
\code{\link[stats]{AIC}}
}
