% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporter-zzz.R
\name{global-data}
\alias{global-data}
\alias{set_testdata}
\alias{get_testdata}
\alias{with_testdata}
\alias{\%E>\%}
\title{Get/set test data}
\usage{
set_testdata(data, quosure = TRUE)

get_testdata()

with_testdata(data, code, quosure = TRUE)

data \%E>\% code
}
\arguments{
\item{data}{Data frame to be used.}

\item{quosure}{If \code{TRUE}, the default, the data frame is stored as a
\link[rlang:quosure]{quosure} and lazily evaluated when \code{get_testdata()} is
called, so \code{get_testdata()} will return the current state of the data
frame.

If \code{FALSE}, the data frame will be copied and \code{get_testdata()} will return
the state of the data frame at the time \code{set_testdata()} was called.}

\item{code}{Code to execute with the test data set to \code{data}.}
}
\value{
\itemize{
\item \code{set_testdata()} invisibly returns the previous test data. The test data
is returned as it was stored - if it was stored with \code{quosure = TRUE} it
will be returned as a quosure.
\item \code{get_testdata()} returns the current test data frame.
\item \code{with_testdata()} and the test data pipe \verb{\%E>\%} invisibly return the
input \code{data} for easy piping.
}
}
\description{
A global test data set is used to avoid having to re-specify the testing data
frame in every test. These functions get and set the global data or set the
data for the current context.
}
\examples{
set_testdata(mtcars)
head(get_testdata())

with_testdata(iris, {
  x <- get_testdata()
  print(head(x))
})

mtcars \%E>\%
  expect_base(mpg, TRUE) \%E>\%
  expect_range(carb, 1, 8)
}
