% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-generic.R
\name{generic-expectations}
\alias{generic-expectations}
\alias{expect_allany}
\alias{expect_all}
\alias{expect_any}
\title{Expectations: generic helpers}
\usage{
expect_allany(
  vars,
  func,
  flt = TRUE,
  data = get_testdata(),
  args = list(),
  allany = c(chk_filter_all, chk_filter_any),
  func_desc = NULL
)

expect_all(...)

expect_any(...)
}
\arguments{
\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{func}{A function to use for testing that takes a vector as the first
argument and returns a logical vector of the same length showing whether an
element passed or failed.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}

\item{args}{A named list of arguments to pass to \code{func}.}

\item{allany}{The function to combine the \code{func} results for each row.}

\item{func_desc}{A human friendly description of \code{func} to use in the
expectation failure message.}

\item{...}{Arguments to pass to \code{expect_allany()}.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
These functions allow for testing of multiple columns (\code{vars}) of a data
frame (\code{data}), with an optional filter (\code{flt}), using an arbitrary function
(\code{func}).
}
\details{
\itemize{
\item \code{expect_allany()} tests the columns in \code{vars} to see whether \code{func}
returns \code{TRUE} for each of them, and combines the results for each row using
the function in \code{allany}. Both \code{expect_all()} and \code{expect_any()} are wrappers
around \code{expect_allany()}.
\item \code{expect_all()} tests the \code{vars} to see whether \code{func} returns \code{TRUE} for
\emph{all} of them (i.e. whether the conjunction of results of applying \code{func} to
each of the \code{vars} is \code{TRUE}).
\item \code{expect_any()} tests the \code{vars} to see whether \code{func} returns \code{TRUE} for
\emph{any} of them (i.e. whether the disjunction of the results of applying \code{func}
to each of the \code{vars} is \code{TRUE}).
}
}
\examples{
# Check that every 4-cylinder car has an engine displacement of < 100 cubic
# inches *AND* < 100 horsepower
try(
expect_all(
  vars = c(disp, hp),
  func = chk_range,
  flt = (cyl == 4),
  args = list(min = 0, max = 100),
  data = mtcars
)
)

# Check that every 4-cylinder car has an engine displacement of < 100 cubic
# inches *OR* < 100 horsepower
try(
expect_any(
  vars = c(disp, hp),
  func = chk_range,
  flt = (cyl == 4),
  args = list(min = 0, max = 100),
  data = mtcars
)
)

# Check petal dimensions are positive
expect_allany(
  vars = where(is.numeric),
  func = chk_range,
  args = list(min = 0, max = Inf),
  allany = chk_filter_all,
  data = iris
)

}
\seealso{
\verb{chk_*()} functions such as \code{\link[=chk-values]{chk_values()}}

Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
